﻿// Program 4
// CIS 200-01
// Fall 2017
// Due: 11/27/2017
// Grading ID: C6597

// File: ParcelDescending.cs
// This program explores sorting using comparers and the natural ordering of classes.
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Prog1
{
    class ParcelDescending : Comparer<Parcel>
    {
        // Precondition:  None
        // Postcondition: Reverses natural parcel order, so descending
        //                When p1 < p2, method returns positive #
        //                When p1 == p2, method returns zero
        //                When p1 > p2, method returns negative #
        public override int Compare(Parcel p1, Parcel p2)
        {
            // Ensure correct handling of null values (in .NET, null less than anything)
            if (p1 == null && p2 == null) // Both null?
                return 0;                 // Equal

            if (p1 == null) // only p1 is null?
                return -1;  // null is less than any actual parcel

            if (p2 == null) // only t2 is null?
                return 1;   // Any actual time is greater than null

            return (-1) * p1.DestinationAddress.Zip.CompareTo(p2.DestinationAddress.Zip); // Reverses natural order, so descending
        }
    }
}
